(defmeth scatterplot-proto :ask-save-pdf ()
	(save-pdf-sc self))


( provide "pdfplot" )



(defun save-pdf-sc (plot &key (backgrid nil) (print-title t) (print-variable t)(font "Courier") (type-font "Type1"))

 ( defproto pdf-plot '( output ) () plot)

  ( defmeth pdf-plot :line-width (&optional (val nil set))
    (when val (setf pdf-val (/ val 2)));lineas ms gordas
	( when set 
		( format (slot-value 'output) " ~d w " pdf-val ) 
        (if (send temp-proto :has-method :line-width :own t)
            (send self :apply-old-method ':line-width val)
            (call-next-method val))
        )
    (if (send self :apply-old-method ':line-width)
        (send self :apply-old-method ':line-width)
        (call-next-method))
    )


  ( defmeth pdf-plot :line-type (&optional (val nil set))
   	(when set
        		(if (eq val 'DASHED)
			(format (slot-value 'output) " [ 3 5 ] 0 d " ) 	; 'DASHED
           			(format (slot-value 'output) " [ ] 0 d " ))	; else 'SOLID 
         (if (send temp-proto :has-method :line-type :own t)
             (send self :apply-old-method ':line-type)
             (call-next-method))
    ))
 	
  ( defmeth pdf-plot :draw-color (&optional (val nil set))
   	( when (and set val)
          (if  (send temp-proto :has-method :draw-color :own t)
               (send self :apply-old-method ':draw-color  val)
         		(call-next-method val))
         		( format (slot-value 'output) "~{ ~f ~} RG ~{ ~f ~} rg "
                    (if 
                     ( parse-color val )
                     (parse-color val) 
                     (list 1  1 1))
                       (if 
                     ( parse-color val )
                     (parse-color val) 
                     (list 1  1 1))))

  	 (if  (send temp-proto :has-method :draw-color :own t)
         (send self :apply-old-method ':draw-color)
       		(call-next-method))
    )
  
  ( defmeth pdf-plot :draw-line (x0 y0 x1 y1)
    (if  (send temp-proto :has-method :draw-line :own t)
         (send self :apply-old-method ':draw-line  x0 y0 x1 y1)
        	( call-next-method x0 y0 x1 y1 ))
   	( format (slot-value 'output) 
           		"~d ~d m ~d ~d l S ~%" x0 y0 x1 y1 ))
  

 #| ( defmeth pdf-plot :draw-line (x0 y0 x1 y1)
    (send self :line-width 1)
        	( call-next-method x0 y0 x1 y1 )
   	( format (slot-value 'output) 
           		"~d ~d m ~d ~d l S ~%" x0 y0 x1 y1 ))|#

  ( defmeth pdf-plot :draw-symbol (symb hi x y)  
    (if  (send temp-proto :has-method :draw-symbol :own t)
         (send self :apply-old-method ':draw-symbol  symb hi x y)
        	( call-next-method symb hi x y ))
    
    ( format (slot-value 'output) " ~d w " 1)
    
    (cond 
      ((equal symb 'CROSS)
       (let ((x (- x 0))
             (y (- y 0)))
         (cond 
           ((not hi)
            ( format (slot-value 'output) 
                   		"~d ~d m ~d ~d l ~d ~d m ~d ~d l s  ~%" x (+ 1.25 y) x (- y 1.25) (+ x 1.25) y (- x 1.25) y))

           (hi 
            ( format (slot-value 'output) 
                     "~d ~d m ~d ~d l ~d ~d m ~d ~d l s  ~%" x (+ 1 y) x (- y 1) (+ x 1) y (- x 1) y)
            (send self :draw-disk-symbol x y 2 2 nil)))))
      ((equal symb 'DIAMOND)
       (let ((x (- x 0))
             (y (- y 0)))
         ( format (slot-value 'output) 
                		"~d ~d m ~d ~d l ~d ~d l ~d ~d l ~d ~d l ~A ~%" (- x 1) y x (+ y 1) 
                  (+ x 1) y x (- y 1) (- x 1) y ( if hi "f" "S"  ))))
      ((equal symb 'X)
       (let ((x (- x 0))
             (y (- y 0)))
         (cond ((not hi)
                ( format (slot-value 'output) 
                       		"~d ~d m ~d ~d l ~d ~d m ~d ~d l ~A ~%" (- x 1) (+ y 1) (+ x 1) (- y 1) 
                         (- x 1) (- y 1) (+ 1 x) (+ y 1) ( if hi  "f" "S")))
           (hi ( format (slot-value 'output) 
                      		"~d ~d m ~d ~d l ~d ~d m ~d ~d l s ~%" (- x .75) (+ y .75) (+ x .75) (- y .75) 
                        (- x .75) (- y .75) (+ x .75) (+ y .75))
               (send self :draw-disk-symbol x y 2 2 nil)))))
      ((equal symb 'DOT)
       ( format (slot-value 'output)                                                                                                              		" ~d ~d m ~d ~d .5 .5 re ~A ~%" (- x 0.25) (- y -.25) (- x .25) (- y .25) ( if hi  "f" "S" )))
      ((equal symb 'DISK)
       (let* (
              (w 4)
              (h 4)
              (xd (/ w 2))
              (yd (/ h 2))
              )
       (if hi (send self :paint-oval (- x xd) (- y yd) w h ) (send self :frame-oval (- x xd) (- y yd) w h ))))
       ; (setf currcolor (send self :draw-color))
       ;(send self :draw-color (send self :back-color))
       ;(send self :paint-oval (- x 1) (- y 1) 2 2 )
       ;  (send self :draw-color currcolor)
       ;(send self :frame-oval (- x 1) (- y 1) 2 2 )
       ; (send self :draw-disk-symbol (- x 0) (- y 0) 1.5 1.5 hi))
       
       
      (t 
       (if hi (send self :paint-rect (- x 1) (- y 1) 2 2 ) (send self :frame-rect (- x 1) (- y 1) 2 2 ))
       ;(setf currcolor (send self :draw-color))
       ; (send self :draw-color (send self :back-color))
       ; ( format (slot-value 'output)                                                                                                              		;" ~d ~d m ~d ~d 1.5 1.5 re ~A ~%" (- x 0.75) (- y 0.75) (- x 0.75) (- y 0.75) 
                  ;          ( if hi  "f" "f\n" ))
       
       ;(send self :draw-color currcolor)
       ;(send self :frame-rect (- x 1) (- y 1) 2 2 )
       
       ))
    ( format (slot-value 'output) " ~d w " (send self :line-width)))
  
  
  ( defmeth pdf-plot :draw-string ( str x y )
    (if  (send temp-proto :has-method :draw-string :own t)
         (send self :apply-old-method ':draw-string  str x y )
        	(call-next-method str x y ))
    
   	(format (slot-value 'output) "BT 1 0 0 -1 0 0 Tm ~d ~d Td (~A) Tj ET~%" 
			 x (- y) str ))
  
  ( defmeth pdf-plot :draw-string-up ( str x y )
    (if  (send temp-proto :has-method :draw-string-up :own t)
         (send self :apply-old-method ':draw-string-up  str x y )
        	(call-next-method str x y))
   	(format (slot-value 'output)
          	 "BT 0 -1 -1 0 0 0 Tm ~d ~d Td (~A) Tj ET~%" 
          	 (- y) (- x) str ))
  
  
  ( defmeth pdf-plot :draw-text ( str x y h v )
   	(if ( = h 1) 
        (setf x (- x (floor ( / ( send self :text-width str) 2)))))
        (if ( = h 2)
            (setf x (- x (send self :text-width str))))
   	(if ( = v 1) 
      		(setf y (+ y  (send self :text-ascent))))
   	(send self :draw-string str x y ))
  
  ( defmeth pdf-plot :draw-text-up ( str x y h v )
   	(if (= h 1)
      		(setf y (+ y (floor 
                   			(/ (send self :text-width str) 2 )))))
   	( setf x ( + x  (send self :text-ascent)))
   	(send self :draw-string-up str x y ))
  
  ( defmeth pdf-plot :frame-rect ( x0 y0 x1 y1 )
    (if  (send temp-proto :has-method :frame-rect :own t)
         (send self :apply-old-method ':frame-rect  x0 y0 x1 y1)
        	(call-next-method x0 y0 x1 y1))

   	(format (slot-value 'output)
          		"\n ~d ~d ~d ~d re S\n" x0 y0 x1 y1 ))
  
  ( defmeth pdf-plot :paint-rect ( x0 y0 x1 y1 )
     (if  (send temp-proto :has-method :paint-rect :own t)
          (send self :apply-old-method ':paint-rect  x0 y0 x1 y1)
         	(call-next-method x0 y0 x1 y1))
    
   	(format (slot-value 'output)
          		"\n ~d ~d ~d ~d re f\n" x0 y0 x1 y1 ))
		
  ( defmeth pdf-plot :make-poly ( points  &optional (from-origin t))
   	( let (( output (slot-value 'output)))
   			(format output " n ~d ~d m " (first (car points)) (second (car points)))
    		( dolist ( pt points )
			(format output " ~d ~d l " (first pt) (second pt)))))
 	
  ( defmeth pdf-plot :frame-poly ( points &optional (from-origin t))
    (if  (send temp-proto :has-method :frame-poly :own t)
          (send self :apply-old-method ':frame-poly points from-origin)
        	(call-next-method points from-origin))
   	(send self :make-poly points from-origin)
	(format (slot-value 'output) " S ~%" ))
  
  ( defmeth pdf-plot :paint-poly ( points &optional (from-origin t))
    (if  (send temp-proto :has-method :paint-poly :own t)
         (send self :apply-old-method ':paint-poly points from-origin)
        	(call-next-method points from-origin))
   	(send self :make-poly points from-origin)
   	(format (slot-value 'output) " f ~%" ))	
  
 ( defmeth pdf-plot :draw-disk-symbol ( x0 y0 w h hi)
   (let* (
          (x0 (- x0 (/ w 2)))
          ;(y0 (- y0 (/ h 2)))
          (h (* h (/ 2 3)))
         (w (/ w 2))
         (x0 (+ x0 (/ w 2)))
         (y0 y0))
   (format (slot-value 'output) " n ~d ~d m ~%" (- x0 (/ w 2)) y0)
   (format (slot-value 'output)
          		"\n ~d ~d ~d ~d ~d ~d c ~% " 
           (- x0 (/ w 2))
           (+ y0 h)
           (+ x0 (+ (/ w 2) w))
           (+ y0 h)
           (+ x0 (+ (/ w 2) w))
           y0 )
   (format (slot-value 'output)
          		"\n ~d ~d ~d ~d ~d ~d c ~A ~%" 
           (+ x0 (+ (/ w 2) w))
           (- y0 h)
           (- x0 (/ w 2)) 
           (- y0 h)
           (- x0 (/ w 2)) 
           y0
           ( if hi "f"  "S"   ))
           ))
 	
 ( defmeth pdf-plot :frame-oval ( x0 y0 w h )
    (if  (send temp-proto :has-method :frame-oval :own t)
         (send self :apply-old-method ':frame-oval x0 y0 w h)
         (call-next-method x0 y0 w h))

     
   (let* (
          (y0 (+ y0 (/ h 2)))
          (h (* h (/ 2 3)))
          (w (/ w 2))
          (x0 (+ x0 (/ w 2)))
          )
         
   (format (slot-value 'output) " n ~d ~d m ~%" (- x0 (/ w 2)) y0)
   (format (slot-value 'output)
          		"\n ~d ~d ~d ~d ~d ~d c ~% " 
           (- x0 (/ w 2))
           (+ y0 h)
           (+ x0 (+ (/ w 2) w))
           (+ y0 h)
           (+ x0 (+ (/ w 2) w))
           y0 )
   (format (slot-value 'output)
          		"\n ~d ~d ~d ~d ~d ~d c S ~%" 
           (+ x0 (+ (/ w 2) w))
           (- y0 h)
           (- x0 (/ w 2)) 
           (- y0 h)
           (- x0 (/ w 2)) 
           y0 )
           )) 
( defmeth pdf-plot :paint-oval ( x0 y0 w h )
    (if  (send temp-proto :has-method :paint-oval :own t)
         (send self :apply-old-method ':paint-oval x0 y0 w h)
         (call-next-method x0 y0 w h))


   (let* (
          (y0 (+ y0 (/ h 2)))
          (h (* h (/ 2 3)))
          (w (/ w 2))
          (x0 (+ x0 (/ w 2)))
          )
         
   (format (slot-value 'output) " n ~d ~d m ~%" (- x0 (/ w 2)) y0)
   (format (slot-value 'output)
          		"\n ~d ~d ~d ~d ~d ~d c ~% " 
           (- x0 (/ w 2))
           (+ y0 h)
           (+ x0 (+ (/ w 2) w))
           (+ y0 h)
           (+ x0 (+ (/ w 2) w))
           y0 )
   (format (slot-value 'output)
          		"\n ~d ~d ~d ~d ~d ~d c f ~%" 
           (+ x0 (+ (/ w 2) w))
           (- y0 h)
           (- x0 (/ w 2)) 
           (- y0 h)
           (- x0 (/ w 2)) 
           y0 )
           ))
  ;; the following are just to add some tracing and debugging
  ;; info to the PDF output file: 
  ;; changed to include the behaviour of basic plot PV
  ;;
  
  ( defmeth pdf-plot :draw-data-lines ( var1 var2 m n)
   	( format (slot-value 'output) "\n%% :DRAW-DATA-LINES\n" )
    (let 	((nv (send self :num-variables))
           (nl (send self :num-lines))
           (nj (iseq m n)))
      ;; check validity of args         
      (when 
       (or (not (< -1 var1 nv)) (not (< -1 var2 nv)))
       (error "Vars: ~A not between 0 and ~d (:num-variables)" 
              (list var2 var2) nv))
      (when 
       (or  (< m 0) (>= n nl))
       (error "index ~a out of range ~a" (list m n) (list 0 nl)))
      
      (let ((save-width (send self :line-width))		 ; save graphics state
            (save-color (send self :draw-color))
            (save-type (send self :line-type))
            (content-rect (send self :content-rect)))  ; to correct for origin
        
        (let* ((widths 	(send self :linestart-width nj))
               (types 	(send self :linestart-type nj))
               (colors 	(send self :linestart-color nj))
               (usecolor (send self :use-color))
               (masked (send self :linestart-masked nj))
               (xsys (mapcar #'(lambda (n) (send self :scaled-to-canvas 
                                                      (send self :linestart-transformed-coordinate var1 n)
                                                      (send self :linestart-transformed-coordinate var2 n)
                                                      ))
                             nj));for printing spinplots
               (xs (if (member spin-proto (send self :precedence-list))
                       (mapcar #'(lambda (pt) (select pt 0)) xsys)
                       (+ (first content-rect)
                   	 (send self :linestart-canvas-coordinate var1 nj))
                       ))
                       ;the first part of the if is for spinplots
               (ys (if (member spin-proto (send self :precedence-list))
                       (mapcar #'(lambda (pt) (select pt 1)) xsys)
                       (- (fourth content-rect)  (- (second content-rect))
                    	         (send self :linestart-canvas-coordinate var2 nj))
                       ))
               )

      (dotimes (i (length nj))
              	( let (( nexti ( send self :linestart-next i)))
                 (when (and nexti (not (elt masked i)))
                       (when (and usecolor (elt colors i)) 
                             (send self :draw-color (elt colors i)))
                       (send self :line-width (elt widths i))
                       (send self :line-type  (elt types i))
                      (send self :draw-line 
                             (elt xs i) (elt ys i)
                             (elt xs nexti) (elt ys nexti))
                       ))))
        (send self :line-width save-width)	; restore graphics state
        (send self :draw-color save-color)
        (send self :line-type save-type)))
    (if (send temp-proto :has-method :draw-data-lines :own t)
        (send self :apply-old-method ':draw-data-lines var1 var2 m n)
        (call-next-method var1 var2 m n))
    
    (values)
   	)
  
  ( defmeth pdf-plot :draw-data-points ( var1 var2 m n)
   	( format (slot-value 'output) "\n%% :DRAW-DATA-POINTS\n" )
    (let 	((nv (send self :num-variables))
           (np (send self :num-points))
           (nj (iseq m n)))
      ;; check validity of args         
      (when 
       (or (not (< -1 var1 nv)) (not (< -1 var2 nv)))
       (error "Vars: ~A not between 0 and ~d (:num-variables)" 
              (list var2 var2) nv))
      (when 
       (or  (< m 0) (>= n np))
       (error "index ~a out of range ~a" (list m n) (list 0 np)))
      
     	(let ((save-color (send self :draw-color))
        		  (content-rect (send self :content-rect)))
        (let* (
               (colors 	(send self :point-color nj))
               (usecolor (send self :use-color))
               (showing (send self :point-showing nj))
               (symbols (send self :point-symbol nj))
               (histate (mapcar #'(lambda (x) (or (eq x 'SELECTED) (eq x 'HILITED)))
                            			(send self :point-state nj)))
               
               (xsys (mapcar #'(lambda (n) (send self :scaled-to-canvas 
                                                      (send self :point-transformed-coordinate var1 n)
                                                      (send self :point-transformed-coordinate var2 n)
                                                      ))
                             nj))
               (xs (if (member spin-proto (send self :precedence-list))
                       (mapcar #'(lambda (pt) (select pt 0)) xsys)
                       (+ (first content-rect)
                        	 (send self :point-canvas-coordinate var1 nj))))
                      
               (ys (if (member spin-proto (send self :precedence-list))
                       (mapcar #'(lambda (pt) (select pt 1)) xsys)
                       (- (fourth content-rect)  (- (second content-rect))
                	         (send self :point-canvas-coordinate var2 nj))))
              )
          (dotimes (i (length nj))
                  	( when ( elt showing i )
                        		( when (and usecolor (elt colors i))
                             			 ( send self :draw-color (elt colors i)))
                          
                          (when (and (send self :showing-labels) (elt histate i))
                                
                              (send self :draw-text (send self :point-label i) (elt xs i) (elt ys i) 1 1)) ;prints labels PV
                        		( send self :draw-symbol 
                              			( elt symbols i ) ( elt histate i ) ( elt xs i ) ( elt ys i )))))
       	(send self :draw-color save-color))) ;; restore graphics state 
    (if (send temp-proto :has-method :draw-data-points :own t)
        (send self :apply-old-method ':draw-data-points var1 var2 m n)
        (call-next-method var1 var2 m n))
    
    (values)
   	)
 	
  ( defmeth pdf-plot :redraw-background ()
   	( format (slot-value 'output) "\n%% :REDRAW-BACKGROUND\n" )
    (let ((dc (send self :draw-color)))
   	  (send self :draw-color (send self :back-color))
   	  (apply #'send self :paint-rect (send self :clip-rect))
   	  (send self :draw-color dc)
   	  (when (send self :has-method :grid-color)		;; backgrid mods included ? 
        	  	(let (( color ( send self :grid-color )))
             	(if color  (send self :draw-grid :color color))
           	 	(if color  (send self :draw-zero-axis :color color))))
      (send self :draw-color dc))
        (if (send temp-proto :has-method :redraw-background :own t)
        (send self :apply-old-method ':redraw-background)
        (call-next-method))
      )
  
 ( defmeth pdf-plot :redraw-axis ()
 	 ( format (slot-value 'output) "\n%% :REDRAW-AXIS\n" )
   (let   ((xrange (send self :range (first (send self :current-variables))))
      		   (yrange (send self :range (second (send self :current-variables))))
      		   (xaxis  (send self :x-axis))
      		   (yaxis  (send self :y-axis))
           (boxplot? (member boxplot-proto (send self :precedence-list)))
           (mosaic? (member mosaic-proto (send self :precedence-list)))
           (stackedbar? (member STACKED-BAR-GRAPH-PROTO (send self :precedence-list)))
           (spin? (member spin-proto (send self :precedence-list)))
           )
     
     (when (or (first xaxis) (first yaxis))
          	(let* ((rxs (rseq (first xrange) (second xrange) (third xaxis)))
             		   (rys (rseq (first yrange) (second yrange) (third yaxis)))
             		   (cxs (mapcar #'(lambda (x) (first (send self :real-to-canvas x 0)))
                          					rxs ))
             		   (cys (mapcar #'(lambda (y) (second (send self :real-to-canvas 0 y)))
                          					rys ))
                  (rxs2 (copy-list rxs))
                  (rys2 (copy-list rys))
                  (cxs2 (copy-list cxs))
                  (cys2 (copy-list cys))
             		   (cx0 (- (first cxs) 0))
             		   (cy0 (- (first cys) 0))
             		   (cxn (- (first (last cxs)) 0))
              		   (cyn (- (first (last cys)) 0))
             		   (lw (send self :line-width))
             		   (c (send self :draw-color)))
           		(if (and (send self :has-method :axis-color)
                 				 (send self :axis-color))
               			(send self :draw-color (send self :axis-color)))
           		(send self :line-width 2)  

             ;THIS PRINTS TITLES IN THE PLOT. SHOULD BE MOVED TO AN OWN METHOD pv
            ;this prints the legend       
             (when print-variable 
		(send self :draw-text 
                   (send self :variable-label (first (send self :current-variables)))
                   (round (mean (list cx0 cxn))) (+ cy0 30) 1 0)
		(send self :draw-text-up 
                   (send self :variable-label (second (send self :current-variables)))
                   (- cx0 40) (round (mean (list cy0 cyn)))  1 0)
	)
             ;draws a white rectangle for the content rectangke
            	(send self :draw-color (send self :back-color))
	 ;(send self :draw-color 'black) ;prueba para ver como queda
             (send self :paint-rect 
                   (- (first (send self :content-rect)) 1) 
                   (- (second (send self :content-rect)) 5)
                   (+ (third (send self :content-rect)) 1)
                   (+ (fourth (send self :content-rect)) 5))
             (send self :draw-color c)
             
             ;this prints the title     
             (if print-title 
		(send self :draw-text 
                   (strcat (send self :title))
                   (round (mean (list cx0 cxn))) (- cyn 60) 1 0))


             ;prints the ticks marks
                
                  	( do ((x (pop cxs) (pop cxs))
                         (rx (pop rxs) (pop rxs)))
                        ((null x))
                        (send self :draw-line (- x 0) (+ cy0 0) (- x 0) (+ cy0 5))
                        (when (not boxplot?)
                              (send self :draw-text (format nil "~4,2f" rx)
                                    x (+ cy0 -10 (send self :text-ascent))  1 1 )
                              ))
            
                   ( do ((y (pop cys) (pop cys))
                         (ry (pop rys) (pop rys)))
                        ((null y))
                        (send self :draw-line (- cx0 1) (- y 0) (- cx0 5) (- y 0))
                        (send self :draw-text-up (format nil "~4,2f" ry)
                             ; (+ 0 20 (send self :text-ascent)) 
                              (- cx0 20)
                              y 1 1 ))
;prints backgrid             
            
             (when backgrid
                   (send self :line-width 1)  
                   (send self :draw-color 'grey)
                   (setf cxs (cdr (reverse (cdr cxs2))))
                   (setf rxs (cdr (reverse (cdr rxs2))))
                   ( do ((x (pop cxs) (pop cxs))
                         (rx (pop rxs) (pop rxs)))
                        ((null x))
                        (send self :draw-line (- x 0) (+ cy0 0) (- x 0) (- cyn 5))
                        )
                   (setf cys (cdr (reverse (cdr cys2))))
                   (setf rys (cdr (reverse (cdr rys2))))
                   ( do ((y (pop cys) (pop cys))
                         (ry (pop rys) (pop rys)))
                        ((null y))
                        (send self :draw-line (- cx0 1) (- y 0) (+ cxn 0) (- y 0))
                        )
                        (send self :draw-color c)
                        (send self :line-width 2)
                   )
  

             ;draws a rectangle fot he content rectangel

              (send self :frame-rect 
                   (- (first (send self :content-rect)) 1) 
                   (- (second (send self :content-rect)) 5)
                   (+ (third (send self :content-rect)) 1)
                   (+ (fourth (send self :content-rect)) 5))


           		(send self :line-width lw) (send self :draw-color c)))))
 	
  ( defmeth pdf-plot :redraw-content ()
    ( format (slot-value 'output) "\n%% :REDRAW-CONTENT\n" )
    
    (send self :redraw-axis)
    (let ((cv (send self :current-variables))
          (nl (send self :num-lines))
          (np (send self :num-points)))
	(when (> np 0) 
            (send self :draw-data-points (first cv) (second cv) 0 (1- np)))
      (when (> nl 0) 
            (send self :draw-data-lines (first cv) (second cv) 0 (1- nl)))
      ;; actually, this (below) seems to be done in draw-data-points
      (when (and (send self :showing-labels) 
                 (send self :has-method :draw-data-strings)) ; NOT IMPL - thus the check 
            (send self :draw-data-strings)))
    (send self :line-width 1)
   	(if (send temp-proto :has-method :redraw-content :own t)
     (send self :apply-old-method ':redraw-content))
   ; (call-next-method)
    

    )
    ;this can be a source of problems but see what happens
	
   	
  (defmeth pdf-plot :redraw-overlays ()
    ) ;PV removes overlays
  (defmeth pdf-plot :legend2 (&optional legend2)
   "" );PV removes legend2
  (defmeth pdf-plot :legend1 (&optional legend1)
    "") ;PV Prints variable name instead of file name

(defmeth pdf-plot :redraw ()
  (if (send temp-proto :has-method :redraw :own t)
        (send self :apply-old-method ':redraw)
        (call-next-method)))

 	(defmeth pdf-plot :resize ()
    (if (send temp-proto :has-method :resize :own t)
        (send self :apply-old-method ':resize)
        (call-next-method)))

  (defmeth pdf-plot :apply-old-method (method &rest args)
    "This method works like a call-next-method but :own-methods are not skipped"
    (when (send temp-proto :has-method method :own t)
          (send temp2-proto :add-method method (send self :get-method method))
          (send self :delete-method method)
           (when (send temp2-proto :has-method method :own t) 
                 (send self :add-method method (send temp-proto :get-method method))
                 (if args (send self method args) (send self method)) )
          (when (send temp2-proto :has-method method :own t) 
                (send self :delete-method method)
                (send self :add-method method (send temp2-proto :get-method method)))))
    

  
  ;; Format template for PDF prelude containing header and 
  ;; initial object definitions that precede the page description.
  ;; Values for MediaBox need to be supplied:
;;   /MediaBox [ ~d ~d ~d ~d ]  
  ;; 
  
  ( setf pdf-header  
         "%PDF-1.0
% Graphics output produced by xlispstat & pdfplot.lsp. 
" )
  
  ( setf pdf-objects 
         (list
          "1 0 obj
<<
/Type /Catalog
/Pages 3 0 R
/Outlines 2 0 R
>>
endobj
"
          
          "2 0 obj
<<
/Type /Outlines
/Count 0
>>
endobj
"
          
"3 0 obj
<<
/Type /Pages
/Count 1
/Kids [ 7 0 R ]
>>
endobj
"
          
"4 0 obj
[
/PDF /Text
]
endobj
"

(format () "5 0 obj
<< 
/Type /Font 
/Subtype /~A
/Name /F1
/BaseFont /~A
/Encoding /MacRomanEncoding
>>
endobj
"
type-font font)

"6 0 obj
<< 
/Type /Font 
/Subtype /Type1
/Name /F2
/BaseFont /ZapfDingbats
/Encoding /MacRomanEncoding
>>
endobj
"

"7 0 obj
<<
/Type /Page
/Parent 3 0 R
/Resources << /Font << /F1 5 0 R   /F2 6 0 R  >>   /ProcSet 4 0 R >>
/MediaBox [ ~d ~d ~d ~d ]
/Contents 8 0 R
>>
endobj
" ))


  ( setf pdf-stream ( list 
                      
"8 0 obj
<< /Length 9 0 R >>
stream
%
BT
/F1 9 Tf
ET
%
% Begin Lisp graphics output
%
~A
%
% End Lisp graphics output 
%
endstream
endobj
"
                      
                      
"9 0 obj
 ~d 
endobj
"
 ))


( setf pdf-trailer-template
"xref
0 10
0000000000 65535 f
~10,48d 00000 n
~10,48d 00000 n
~10,48d 00000 n
~10,48d 00000 n
~10,48d 00000 n
~10,48d 00000 n
~10,48d 00000 n
~10,48d 00000 n
~10,48d 00000 n
trailer
<<
/Size 11
/Root 1 0 R
>>
startxref
~d
%%EOF
" )






( defun make-pdf-string ( graph-pdf &optional (output nil output-assigned))
  ;first save the owner methods of the plot
  (setf temp-proto (make-object))
  (setf temp2-proto (make-object))
  ( dolist ( meth ( send graph-pdf :own-methods ))
         		( send temp-proto :add-method meth ( send graph-pdf :get-method meth )))
  ;second put the pdf methods in plot 
	( dolist ( meth ( send pdf-plot :own-methods ))
		( send graph-pdf :add-method meth ( send pdf-plot :get-method meth )))


	(if (null output-assigned) (setf output (make-string-output-stream)))
	( send graph-pdf :add-slot 'output output )
	( format output "1 0 0 -1 0 ~d cm ~%" ( second ( send graph-pdf :size )))
	( send graph-pdf :redraw )

;third delete the pdf methods from plot
	( dolist ( meth ( send pdf-plot :own-methods ))
		( send graph-pdf :delete-method meth ))

;fourth add the old plots to plot
  ( dolist ( meth ( send temp-proto :own-methods ))
         		( send graph-pdf :add-method meth ( send temp-proto :get-method meth )))
  
  (send graph-pdf :redraw) ;rebuilds the plot


	(if (null output-assigned) (get-output-stream-string output)
								output ))



(write-pdf plot )


  plot)